import json
import logging
from utils import (
    bytes_to_int,
    hex_string_to_int,
    SHA256_LEN_BYTES,
    SHA384_LEN_BYTES
)
from cse_image_items.BaseItem import BaseItem
from cse_image_items.DataItem import DataItem

logger = logging.getLogger(__name__)
EXTENSION_JSON = 'layout/extension.json'

try:
    with open(EXTENSION_JSON) as extension_json:
        extension = json.load(extension_json)
except IOError:
    logger.exception('extensions layout file does not exist')
    raise IOError('extensions layout file does not exist')


class ExtensionFactory(object):
    @staticmethod
    def create(value, offset):
        # TODO:Delete create funcion
        extension_type = hex(bytes_to_int(value[offset:offset + 4]))
        return Extension(data=value, offset=hex(offset))


class Extension(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START Extension.__init__ FUNCTION')
        
        super(Extension, self).__init__(data, **extension)
